import os
import csv

class Companies(object):


    def __init__(self):
        super(Companies, self).__init__()
        self.arr = []
        self.arrsorted = []

    def load_comp(self, file, limit):
        """Loads the array with companies given a filename.
           Returns True if successful, False otherwise.
           We are calling the function with data.csv
	 """

        if not os.path.exists(file):
            print("The filename that you entered does not exist! ")
            file = raw_input("Please provide the correct filename")

        if file.endswith(".csv"):
            """The below with statement will automatically close the file after the nested block of code.
             It is guaranteed to close the file no matter how the nested block exits.
            """
            with open(file) as csvf:

                """To read data from a csv file, we use the reader function to create a reader object.
                    The reader function will take each line of the file and make a list containing
                    all that line's columns. Then we can just pick the columns we are interested in.
                """
                spamreader = csv.reader(csvf, delimiter=';', quotechar='|')
                for n, row in enumerate(spamreader):

                    if n == 0:
                        #the first row contains the number of rows
                        continue
                    limit1 = limit + 1
                    #the user entered the size of the db. we add one more row at the top of the file which contains only one column with the size of the db
                    if n == limit1:
                        #the predefined db size inserted by the user
                        break
                    id = row[0]
                    title = row[1]
                    summary = row[2]
                    num_of_emp = int(row[3])

                    employees = []

                    for n in range(0,num_of_emp):
                        #the num of employees is defined in col3 and their names are found in col4 to col10
                        st = row[4 + n].split()
                        map(lambda s: s.strip() + " ", st)
                        name = "".join(st[-2])
                        surname = st[-1]
                        employees.append(Employee(name, surname))

                    self.arr.append(Company(id, title, summary, employees))

                self.arrsorted = sorted(self.arr, key=lambda x: x.id, reverse=False)

        else:
            print("Unsupported file format, please try a csv file")
            return False

    def save_comp(self,file):

        try:
            with open(file, 'wb') as f:

                writer = csv.writer(f)
                dbsize = str(len(self.arr))
                writer.writerow( (dbsize) )
                #the first row contains the size of the db
                for i in self.arr:
                   # print self.arr
                    l = str(len(i.employees))
                    sum = i.summary
                    e = [i.id + ";" + i.title + ";" + l + ";" + sum] + [k.firstname + " " + k.lastname for k in i.employees]

                    w = ";".join(e)
                    print w
                    writer.writerow([w])


                return True
        except OSError:
            print("The file cannot be opened for writing")
            return False

    def add_comp(self):
        id = raw_input("Please enter the id")
        title = raw_input("Please enter the title of the company")
        descr = raw_input("Now enter the description of the company")
        employees_string = raw_input("Finally enter the employees of the company separated by commas (e.g. Ioannaki Tzanetou, John Doe,..")
        empl_list = employees_string.split(',')
        employees = []

        for empl in empl_list:
            name_surname = empl.split()
            name = name_surname[0]
            surname = name_surname[1]
            employees.append(Employee(name, surname))

        try:
            self.arr.append(Company(id, title, descr, employees))
            self.arrsorted = sorted(self.arr, key = lambda x: x.id, reverse = False)
            return True
        except:
            print("Couldn't add the company to the list")

            return False

    def delete_comp(self, id):
        """Delete a company based on id.Linear time."""
        for company in self.arr:
            if company.id == id:
                self.arr.remove(company)
            	self.arrsorted = sorted(self.arr, key = lambda x: x.id, reverse = False)
		print("Company was deleted successfully")

    def disp_comp(self):
        """Print all companies in the database."""
        for company in self.arr:
            print (company)

    def disp_id(self, id):
        """Print a company based on id. Linear time."""
        for company in self.arr:
            if company.id == id:
                return company
        return None

    def disp_surname(self, surname):
        l = []
        for company in self.arr:
            surnames = [e.lastname for e in company.employees]
            if surname in surnames:
                l.append(company)
        if len(l) > 0 :
            return l
        else:
            return None


    def binary_search(self, x, a = None, lo=0, hi=None):
        """Search for a company based on id.
        Implements binary search, which should have an average complexity of log(n)."""

        if hi is None:
            a = self.arrsorted
            hi = len(a)
        while lo < hi:
            mid = (lo+hi)//2
            midval = a[mid]
            if midval.id < x:
                lo = mid+1
            elif midval.id > x:
                hi = mid
            else:
                return a[mid]
        return None

class Employee(object):
        """Employee has a name and a surname for each employee"""

        def __init__(self, name, surname):
            super(Employee, self).__init__()
            self.firstname = name
            self.lastname = surname

        def __str__(self):
            return "Name:" + self.firstname + " Surname: " + self.lastname

class Company(object):
                    """Company has an id, title, description and some Employees."""
                    employees = []
                    def __init__(self, id, title, summary, employees):
                        super(Company, self).__init__()
                        self.id = id
                        self.title = title
                        self.summary = summary
                        self.employees = employees

                    def __str__(self):
                        empl = [ str(x) + " " for x in self.employees ]
                        temp  = " Id : {}".format( self.id ) +  " " + "Title : " + self.title + " " + "Employees : "
                        temp += ''.join(empl)
                        return temp

                    def __lt__(self, other):
                        if type(other) == Company:
                            return self.id < other.id
                        elif type(other) == str:
                            return self.id < other
                        else:
                            raise Exception("don't know how to compare")

                    def __gt__(self, other):
                        if type(other) == Company:
                            return self.id > other.id
                        elif type(other) == str:
                            return self.id > other
                        else:
                            raise Exception("don't know how to compare")




__defaultfile__   = ""

