import sys, companyfuncs


def menu():
    print """
    Select an operation by entering a number from 1-8
    1. Load companies from file
    2. Save companies to file
    3. Add a company
    4. Delete a company by id
    5. Display a company by id
    6. Display companies
    7. Display companies by surname search
    8. Exit
    """

    choice = raw_input()
    return int(choice)


def main():
    if len(sys.argv) > 1:
        name = sys.argv[1]

    else:
        name = "data.csv"

    print 'The operations will be applied on the file:', name
    c = companyfuncs.Companies()
    opt = 0
    while opt != 8:

        opt = menu()

        if opt == 1:
        #delete and reload array of companies
            if len(c.arr) > 1:
                 del c.arr[0:len(c.arr)]
            #data.csv has 10.000 rows, we can experiment with less
            size = 10000
            q = raw_input("Default size is 10.000, do you want to minimize the database? y/n")
            if q == "y":
                size = int(raw_input("Please enter a size for the database 0-10.000"))
            c.load_comp(name, size)

        elif opt  == 2:
            if not c.save_comp("data1.csv"):
                print("Oups, something went wrong!")
        elif opt == 3:
            c.add_comp()
        elif opt == 4:
            iid = raw_input("Please enter the ID that you want to delete")
            c.delete_comp(iid)
        elif opt == 5:
            iid = str(raw_input("Please enter the ID that you want to display"))
            mycompany = c.disp_id(iid)
            print(mycompany)

        elif opt == 6:
            c.disp_comp()
        elif opt == 7:
            title = raw_input("Please enter the surname of the employee that you want to display")
            mycompany_list = c.disp_surname(title)
            for c1 in mycompany_list:
                print(c1)



main()
