import copy
import argparse

parser = argparse.ArgumentParser()
parser.add_argument("-p", "--plot", help="Use matplotlib to plot performance graphs",
                    action="store_true")
args = parser.parse_args()
if args.plot:
    import matplotlib.pyplot as plt
import sys
import time
import os
import companyfuncs
import trie
import avl
import csv


def checkResults():
    return res0 == res1 == res2 and res3 == res4


def ioannaki():

    l = list()
    limit = 5000
    with open("data.csv") as csvf:
        spamreader = csv.reader(csvf, delimiter=';', quotechar='|')
        for n, row in enumerate(spamreader):
            if n == 0 or n % 5 != 0:
                #the first row contains the number of rows
                continue
            limit1 = limit + 1
            #the user entered the size of the db. we add one more row at the top of the file which contains only one column with the size of the db
            if n == limit1:
                #the predefined db size inserted by the user
                break
            id = row[0]
            num_of_emp = int(row[3])

            for n in range(0,num_of_emp):
                #the num of employees is defined in col3 and their names are found in col4 to col10
                st = row[4 + n].split()
                map(lambda s: s.strip() + " ", st)
                surname = st[-1]
            l.append((id, surname))

    return l

test_items = ioannaki()
endresults = {}

for size in range(500, 2100, 500):
    start = [0, 0, 0, 0, 0,]
    end = [0, 0, 0, 0, 0]
    avg = [0, 0, 0, 0, 0]

    print("Size is {}".format(size))
    c = companyfuncs.Companies()
    c.load_comp("data.csv", size)
    surname_trie = trie.Trie()
    id_avl = avl.AVLTree()

    surname_trie.build_employees(c.arr)
    id_avl._buildMe(c.arr)
    cnt = 0
    for (iid, ssurname) in test_items:
        cnt += 1
        #linear search by id
        start[0] = time.time()
        res0 = c.disp_id(iid)
        end[0] = time.time()

        #binary search by id
        start[1] = time.time()
        res1 = c.binary_search(iid)
        end[1] = time.time()


        #avl search id
        start[2] = time.time()
        res2 = id_avl.find(iid)
        end[2] = time.time()

        #linear search by surname
        start[3] = time.time()
        res3 = c.disp_surname(ssurname)
        end[3] = time.time()


        #trie search by surname
        start[4] = time.time()
        res4 = surname_trie.lookup(ssurname)
        end[4] = time.time()

        avg = [a + e - s for a, e, s in zip(avg, end, start)]

    if not checkResults:
        print("Error!")
        exit()
    else:
        endresults[size] = copy.deepcopy([a / cnt for a in avg])  # create a copy of avg and store it

for item in endresults:
    print("===============Times===============")
    print("id Linear search: {}".format(endresults[item][0]))
    print("id Binary search: {}".format(endresults[item][1]))
    print("id avl search: {}".format(endresults[item][2]))
    print("---------------------------------")
    print("surname linear: {}".format(endresults[item][3]))
    print("surname trie: {}".format(endresults[item][4]))

sizes = endresults.keys()
tmp = [0, 0, 0, 0, 0]
for it in range(5):
    tmp[it] = [endresults[i][it] for i in endresults.keys()]
if args.plot:
    plt.figure(1)
    p1 = plt.plot(sizes, tmp[0], 'bo')
    p2 = plt.plot(sizes, tmp[1], 'go')
    p3 = plt.plot(sizes, tmp[2], 'ro')
    p11 = plt.Circle(1, 1, fc="b")
    p12 = plt.Circle(1, 1, fc="g")
    p13 = plt.Circle(1, 1, fc="r")
    plt.legend([p11, p12, p13], ["Linear id search", "Binary id search", "Avl id search"])
    plt.ylabel("Time in seconds")
    plt.xlabel("Database size")
    plt.xlim([0,2500])

    plt.figure(2)
    p4 = plt.plot(sizes, tmp[3], 'go')
    p5 = plt.plot(sizes, tmp[4], 'bo')
    p21 = plt.Circle(1, 1, fc="g")
    p22 = plt.Circle(1, 1, fc="b")
    plt.legend([p21, p22], ["Linear surname search", "Trie surname search"])
    plt.ylabel("Time in seconds")
    plt.xlabel("Database size")
    plt.xlim([0,2500])

    plt.show()

